<?php

namespace App\Models;

use CodeIgniter\Model;

class Users_model extends Model
{
    protected $DBGroup = 'default';
    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = true;

    protected $allowedFields = ['id', 'username', 'active', 'first_name', 'last_name', 'ip_address', 'password', 'email', 'balance', 'activation_selector', 'activation_code', 'forgotten_password_selector', 'forgotten_password_code', 'forgotten_password_time', 'remember_selector', 'remember_code', 'created_on', 'last_login', 'company', 'phone', 'fcm_id', 'image', 'api_key', 'friends_code', 'referral_code', 'city_id', 'city', 'latitude', 'longitude'];
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $useTimestamps = true;


    public function get_records($select_field = '*', $where = '')
    {
        $this->builder()->like("email", $where, 'before');
        $this->builder()->like("first_name", $where);
        $this->builder()->like("last_name", $where);
        $this->builder()->select($select_field);

        $data = [];

        foreach ($this->builder()->get()->getResultArray() as $record) {
            $data[] = array("id" => $record['id'], "email" => $record['email']);
        }
        return $data;
    }

    public  function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'pd.id', $whereIn = [])
    {

        $multipleWhere = '';
        $db      = \Config\Database::connect();

        $builder = $db->table('users u');
        if ($search and $search != '') {
            $multipleWhere = [
                '`u.id`' => $search,
                '`u.username`' => $search,
                '`u.email`' => $search,
                '`u.phone`' => $search,
            ];
        }
        $builder->select(' COUNT(u.id) as `total` ')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', "2");

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        $user_count = $builder->get()->getResultArray();

        $total = $user_count[0]['total'];
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        $builder->select('u.*,ug.group_id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', "2");
        $user_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();


        foreach ($user_record as $row) {


            if ($from_app) {
                if (!empty($row['image'])) {
                    $row['image'] = base_url('public/backend/assets/profiles/' . $row['image']);
                }
            }

            if ($row['image'] != '') {
                if (check_exists(base_url('public/backend/assets/profiles/' . $row['image']))) {
                    $profile = '<a  href="' . base_url('public/backend/assets/profiles/' . $row['image'])  . '" data-lightbox="image-1"><img height="100px" width="100px" class="rounded-circle" src="' . base_url("public/backend/assets/profiles/" . $row['image']) . '" alt=""></a>';
                } else {
                    $profile = '
                        <a href="#" id="pop">
                            <img id="profile_picture" src="' . base_url('public/backend/assets/profiles/default.png') . '" height="100px" width="100px" class="rounded-circle">
                        </a>';
                }
            } else {
                $profile = '<a href="#" id="pop">
                        <img id="profile_picture" src="' . base_url('public/backend/assets/profiles/default.png') . '" height="100px" width="100px"  class="rounded-circle">
                    </a>';
            }

            $profile =
                '<li class="media p-2" >' . $profile . ' <div class="media-body"> <div class="media-title mt-3">' .     $row['username'] . '</div>
                <div class="text-job text-muted">' . $row['email'] . '</div></div></li>';

            // logical part
            // operations on user
            $operations = ($row['active'] == 1) ?
                '<button class="btn btn-warning deactivate_user" title="Deactivate Customer"> <i class="fa fa-ban" aria-hidden="true"></i> </button>'
                :
                '<button class="btn btn-success activate_user" title="Activate Customer"> <i class="fa fa-check" aria-hidden="true"></i> </button> ';

            // status of user
            $status = ($row['active'] == 1) ?
                '<div class="badge badge-success projects-badge">Active</div>'
                :
                '<div class="badge badge-warning projects-badge">Deactivated</div>';
            // 

            $tempRow['id'] = $row['id'];
            $tempRow['image'] = $profile;
            $tempRow['username'] = $row['username'];
            $tempRow['active'] = $status;
            $tempRow['operations'] = $operations;
            $tempRow['email'] = ($row['email'] != "") ? $row['email'] : "No Email Provided";

            $tempRow['phone'] = $row['phone'];

            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;


            // print_r($bulkData['rows']);
            return $bulkData;
        }

          
    }

    public function get_user($user_id,$select_field = '*')
    {
       
        $this->builder()->select($select_field)->where(['id'=>$user_id]);

        $data = $this->builder()->get()->getResultArray();

        return $data;
    }
}
